/*
 * World.h
 *
 * Created 8/16/2009 By Johnny Huynh
 *
 * Version 00.00.01 8/16/2009
 *
 * Copyright Information:
 * All content copyright  2009 Johnny Huynh. All rights reserved.
 */
 
 #ifndef WORLD_H
 #define WORLD_H
 
 template <typename T> class World;
 
 #include "global.h"
 
 #include "MapArea.h"
 #include "TestMapArea.h"
 #include "pointerTo.h"
 #include "windowFramework.h"
 #include "CameraAdjustment.h"
 
 /**
  * Class specification for World
  */
 template <typename T>
 class World
 {
 // Data Members
 protected:
    PT(WindowFramework) _window_Ptr;
    //NodePath _cam; // camera
    PT(MapArea<T>) _map_area_Ptr;
 
 // Local Functions
 public:
    World( WindowFramework& window );
    World( const World<T>& world );
    virtual ~World();
    inline World<T>& operator=( const World<T>& world );
    inline MapArea<T>* get_map_area();
    inline NodePath get_scene_graph_root_node_path();
    //inline NodePath& get_camera();
    inline void load_world(); // this must be called immediately after a World is created
    
 // Private Functions
 private:
    
 // Friend Functions
 public:
    
 };
 
 /** LOCAL FUNCTIONS **/
 
 /**
  * Constructor
  */
 template <typename T>
 World<T>::World( WindowFramework& window )
          : _window_Ptr( &window ),
            //_cam( window.get_camera_group() ),
            //_map_area_Ptr( new TestMapArea<T>( window.get_render(), _cam ) )
            _map_area_Ptr( new TestMapArea<T>( window.get_render(), window.get_camera_group() ) )
 {
    nassertv( _window_Ptr != NULL );
    //nassertv( !_cam.is_empty() );
    nassertv( _map_area_Ptr != NULL );
    //load_world();
 }
 
 /**
  * Copy Constructor
  */
 template <typename T>
 World<T>::World( const World<T>& world )
          : _window_Ptr( world._window_Ptr ),
            //_cam( world._cam ),
            _map_area_Ptr( world._map_area_Ptr )
 {
    
 }
 
 /**
  * Destructor
  */
 template <typename T>
 World<T>::~World()
 {
    
 }
 
 /**
  * operator=() copies the content of the specified World to this World.
  *
  * @param (const World<T>&) world
  * @return World<T>&
  */
 template <typename T>
 inline World<T>& World<T>::operator=( const World<T>& world )
 {
    _window_Ptr = world._window_Ptr;
    //_cam = world._cam;
    _map_area_Ptr = world._map_area_Ptr;
    
    return *this;
 }
 
 /**
  * get_map_area() returns a pointer to the current MapArea in this World.
  *
  * @return MapArea<T>*
  */
 template <typename T>
 inline MapArea<T>* World<T>::get_map_area()
 {
    return _map_area_Ptr;
 }
 
 /**
  * get_scene_graph_root_node_path() returns a NodePath to the root node of the
  * scene graph.
  *
  * @return NodePath
  */
 template <typename T>
 inline NodePath World<T>::get_scene_graph_root_node_path()
 {
    return _window_Ptr->get_render();
 }
 
 /**
  * get_camera() returns the camera of this World.
  *
  * @return NodePath&
  */
 //template <typename T>
 //inline NodePath& World<T>::get_camera()
 //{
 //   return _cam;
 //}
 
 /**
  * load_world() initializes the necessary components for starting this World.
  */
 template <typename T>
 inline void World<T>::load_world()
 {
    if ( global::_player_1_handler_Ptr == NULL )
    {
        // load _player_1's character
        PT(Ralph<T>) ralph_Ptr( new Ralph<T>() );
        // assert memory has been allocated to construct the player's character
        nassertv( ralph_Ptr != NULL )
        
        ralph_Ptr->load_model( *_window_Ptr, _window_Ptr->get_render() );
        
        global::_player_1_handler_Ptr = new InputConfig<T>( ralph_Ptr, _window_Ptr->get_camera_group() );//_cam );
    }
    
    NodePath& cam( global::_player_1_handler_Ptr->get_camera() );
    Ralph<T>& character( *global::_player_1_handler_Ptr->get_character() );
    
    _map_area_Ptr->add_object( &character );
    
    _map_area_Ptr->populate_map_area( *_window_Ptr );
    
    // Set up the camera
    // This must occur after loading the model(s) for the player(s)
    cam.set_z( CAMERA_HEIGHT + character.get_z() );
    CameraAdjustment::adjust_camera_to_first_person_character( cam, character, CAMERA_XY_DISTANCE );
 }
 
 /** PRIVATE FUNCTIONS **/
 
 /** FRIEND FUNCTIONS **/
 
 #endif // WORLD_H